﻿using System.IO;
using System.Net.Security;
using System.Security.Authentication;
using System.Security.Cryptography.X509Certificates;

namespace DicomSecurityDemo
{
    class MinimalWindowsClient
    {
        internal Stream TlsStream(Stream InnerStream, string RemoteAddress, int RemotePort)
        {
            var s = new SslStream(InnerStream, false, ValidateWindowsCertificate, GetClientCertificate);
            s.AuthenticateAsClient(RemoteAddress);
            return s;
        }

        private X509Certificate GetClientCertificate(object sender, string targetHost, X509CertificateCollection localCertificates, X509Certificate remoteCertificate, string[] acceptableIssuers)
        {
            if (Form1.MainForm.ProvideClientCertificate.Checked)
                return new X509Certificate2(SecureConnection.Properties.Resources.client, "password");
            else
                return null;
        }

        //this one is for the SCU to validate the server's certificate
        public bool ValidateWindowsCertificate(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            // this is the Windows validator for the client to check the server's certificate
            // Most checks are disabled for testing purposes, leaving only absence of a client certificate if requested
            if (sslPolicyErrors.HasFlag(SslPolicyErrors.RemoteCertificateNotAvailable))
                return false;

            Form1.MainForm.SetServerCert(certificate?.Subject + "(Windows)");

            return true;
        }
    }

    class MinimalWindowsServer
    {
        internal static Stream GetDecryptedStream(Stream EncryptedStream, string RemoteAddress, int LocalPort)
        {
            var Certificate = new X509Certificate2(SecureConnection.Properties.Resources.server, "password");

            SslStream ssl = new SslStream(EncryptedStream, false, ValidateWindowsCertificate);
            ssl.AuthenticateAsServer(Certificate, Form1.MainForm.RequestClientCertificate.Checked, SslProtocols.Tls, false);
            return ssl;
        }

        //this one is for the SCP to validate the client's certificate (if provded)
        public static bool ValidateWindowsCertificate(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            // this is the Windows validator for the client to check the server's certificate
            // Most checks are disabled for testing purposes, leaving only absence of a client certificate if requested
            if (sslPolicyErrors.HasFlag(SslPolicyErrors.RemoteCertificateNotAvailable) && Form1.MainForm.RequestClientCertificate.Checked)
                return true;

            Form1.MainForm.SetClientCert(certificate?.Subject + "(Windows)");

            return true;
        }
    }

}
